VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsUTF8"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'---------------------------------------------------------------------------------------
' Module    : clsUTF8
' Date      : 6/23/2004
' Author    : Skywing
' Purpose   : Class for UTF-8 string conversions
'---------------------------------------------------------------------------------------

Private Declare Function MultiByteToWideChar Lib "kernel32" (ByVal CodePage As Long, ByVal dwFlags As Long, ByVal lpMultiByteStr As String, ByVal cchMultiByte As Long, ByVal lpWideCharStr As String, ByVal cchWideChar As Long) As Long
Private Declare Function WideCharToMultiByte Lib "kernel32" (ByVal CodePage As Long, ByVal dwFlags As Long, ByVal lpWideCharStr As String, ByVal cchWideChar As Long, ByVal lpMultiByteStr As String, ByVal cchMultiByte As Long, ByVal lpDefaultChar As String, ByVal lpUsedDefaultChar As Long) As Long

Private Const CP_ACP = 0
Private Const CP_UTF8 = 65001

Public Function UTF8Encode(Str As String) As String
    Dim InputChars As Long
    InputChars = Len(Str)
    'We need to first convert the ASCII input to Unicode before we can convert it to UTF-8...
    Dim UnicodeChars As Long, UnicodeBuffer As String
    UnicodeChars = MultiByteToWideChar(CP_ACP, 0, Str, InputChars, vbNullString, 0)
    UnicodeBuffer = Space(UnicodeChars * 2)
    MultiByteToWideChar CP_ACP, 0, Str, InputChars, UnicodeBuffer, UnicodeChars
    'Now that we've got everything translated to Unicode, we can (finally) convert it to UTF-8.
    Dim UTF8Chars As Long, UTF8Buffer As String
    UTF8Chars = WideCharToMultiByte(CP_UTF8, 0, UnicodeBuffer, UnicodeChars, 0, 0, vbNullString, 0)
    UTF8Buffer = Space(UTF8Chars)
    WideCharToMultiByte CP_UTF8, 0, UnicodeBuffer, UnicodeChars, UTF8Buffer, UTF8Chars, vbNullString, 0
    UTF8Encode = UTF8Buffer
End Function

Public Function UTF8Decode(Str As String) As String
    Dim InputBytes As Long
    InputBytes = Len(Str)
    'Again, we need to convert the UTF-8 string to Unicode before we can convert it to 8-bit.
    Dim UnicodeChars As Long, UnicodeBuffer As String
    UnicodeChars = MultiByteToWideChar(CP_UTF8, 0, Str, InputBytes, vbNullString, 0)
    UnicodeBuffer = Space(UnicodeChars * 2)
    MultiByteToWideChar CP_UTF8, 0, Str, InputBytes, UnicodeBuffer, UnicodeChars
    'Now that we've got everything translated to Unicode, we can convert it to 8-bit characters.
    Dim SingleByteChars As Long, SingleByteBuffer As String
    SingleByteChars = WideCharToMultiByte(CP_ACP, 0, UnicodeBuffer, UnicodeChars, vbNullString, 0, vbNullString, 0)
    SingleByteBuffer = Space(SingleByteChars)
    WideCharToMultiByte CP_ACP, 0, UnicodeBuffer, UnicodeChars, SingleByteBuffer, SingleByteChars, vbNullString, 0
    UTF8Decode = SingleByteBuffer
End Function
